#!/usr/bin/env perl

use strict;
use Digest::MD5 qw(md5_hex);
my $f_remove_unused_eps = 0;

if (@ARGV != 1) {
    die 'wrong number of argument';
}
my $prnfile = $ARGV[0];    

my $basename = $prnfile; $basename =~ s/\.prn$//;
my $dirname = $prnfile; $dirname =~ s![^/]*$!!;
my $notedumpfile  = $basename . '.note.txt';
my $md5file  = $basename . '.md5';

my %prev_md5 = ();
my %curr_md5 = ();

if (-e $md5file) {
    open(MD5, $md5file) or die;
    while (<MD5>) {
        if (/^([01-9a-f]+)\s+([-_01-9a-zA-Z]+)/) {
            $prev_md5{$1} = $2;
        }
    }
    close(MD5);
}

my $counter = 1;
open(NOTES, $notedumpfile) or die;
while (<NOTES>) {
    if (/\014/) {
        $counter++;
    }
    if (/\@file=([-_01-9a-zA-Z]+)/) {
        my $epsbase = $1;
        my $page = $counter;
        my $pngfile = $basename . '.ppt.tmp_slide' . $page . '.png';
        my $md5;
        if (-e $pngfile) {
            $md5 = md5_hex(`cat $pngfile`);
            $curr_md5{$md5} = $epsbase;
        } else { # can't happen
            die "no png file: $pngfile";
        }

        if (exists $prev_md5{$md5}) {
            if ($prev_md5{$md5} eq $epsbase) {
                # not changed
                delete $prev_md5{$md5};
            } else {
                system("mv $dirname$prev_md5{$md5}.eps $dirname$epsbase.eps");
                delete $prev_md5{$md5};                
            }
        } else {
            system("psselect $page $prnfile > $dirname$epsbase.ps");
            system("ps2eps -R + -B -f $dirname$epsbase.ps");
            system("ps2eps -C $dirname$epsbase.eps");
            system("mv $dirname$epsbase.eps.eps $dirname$epsbase.eps");
            system("rm $dirname$epsbase.ps");
        }
    }
}
close(NOTES);

if ($f_remove_unused_eps) {
    # to be implemented
}

open(MD5, '>', $md5file) or die;
foreach my $m (keys %curr_md5) {
    print MD5 $m . "\t" . $curr_md5{$m} . "\r\n";
}
close(MD5);
system("rm " . $basename . '.ppt.tmp_slide*.png');
